package w83b.w83bBeans;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasDocsBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bDocBean.
 * @author a
 */
public class W83bDocBean extends W83bBaseBean implements W83bBaseBeanBD{

	/** The id. */
	public String id="";
	
	/** The nombre. */
	private String nombre="";
	
	/** The tipo documento. */
	private String tipoDocumento="";

	
	/** The fecha registro. */
	private String fechaRegistro="";
	
	/** The numero registro. */
	private String numeroRegistro="";
	
	/** The usuario. */
	private String usuario="";
	
	/** The file data. */
	private InputStream fileData;
	
	/** The file data blob. */
	private Blob fileDataBlob;
	
	private StringBuffer documento;
	
	/** The cod fase. */
	private String codFase;
	
	/** The cod tramite. */
	private String codTramite;
	
	/** The desc tipo. */
	private String descTipo;
	
	/** The dese tipo. */
	private String deseTipo;
	
	/** The desc tipo. */
	private String descFase;
	
	/** The dese tipo. */
	private String deseFase;
	
	/** The desc tipo. */
	private String descTramite;
	
	/** The dese tipo. */
	private String deseTramite;
	
	/** The tamanyo. */
	private int tamanyo;
	
	/** The num acta. */
	private String  numActa = "";
	
	/** The num acta territorio. */
	private String  numActaTerritorio = "";
	
	/** The num acta ano. */
	private String  numActaAno = "";
	
	/** The version acta. */
	private String  versionActa = "";
	
	private String flag = "";
	
	private String escomunicacion = "";
	
	private String numInc = "";
	private String numIncAno = "";
	private String numIncTerritorio = "";
	private W83bLotesPreavisosBean lotesPreavisosBean;
	
	
	private String numPreaviso;
	private String numPreavisoAno;
	private String numPreavisoTerritorio;
	
	private String numImpugnacion;
	private String numImpugnacionAno;
	private String numImpugnacionTerritorio;
	
	//Campos acuses de recibo
	private String idRemesaAcuse;
	private String codRemesaAcuse;
	private String idColeccionAcuse;
	private String codColeccionAcuse;
	private String idEnvioAcuse;
	private String codEnvioAcuse;
	
	private String destinatarioComunicLaudo="";
	
	

	public String getCodColeccionAcuse() {
		return codColeccionAcuse;
	}

	public void setCodColeccionAcuse(String codColeccionAcuse) {
		this.codColeccionAcuse = codColeccionAcuse;
	}

	public String getCodEnvioAcuse() {
		return codEnvioAcuse;
	}

	public void setCodEnvioAcuse(String codEnvioAcuse) {
		this.codEnvioAcuse = codEnvioAcuse;
	}

	public String getCodRemesaAcuse() {
		return codRemesaAcuse;
	}

	public void setCodRemesaAcuse(String codRemesaAcuse) {
		this.codRemesaAcuse = codRemesaAcuse;
	}

	public String getIdColeccionAcuse() {
		return idColeccionAcuse;
	}

	public void setIdColeccionAcuse(String idColeccionAcuse) {
		this.idColeccionAcuse = idColeccionAcuse;
	}

	public String getIdEnvioAcuse() {
		return idEnvioAcuse;
	}

	public void setIdEnvioAcuse(String idEnvioAcuse) {
		this.idEnvioAcuse = idEnvioAcuse;
	}

	public String getIdRemesaAcuse() {
		return idRemesaAcuse;
	}

	public void setIdRemesaAcuse(String idRemesaAcuse) {
		this.idRemesaAcuse = idRemesaAcuse;
	}

	public W83bLotesPreavisosBean getLotesPreavisosBean() {
		return lotesPreavisosBean;
	}

	public void setLotesPreavisosBean(W83bLotesPreavisosBean lotesPreavisosBean) {
		this.lotesPreavisosBean = lotesPreavisosBean;
	}

	public StringBuffer getDocumento() {
		return documento;
	}

	public void setDocumento(StringBuffer documento) {
		this.documento = documento;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getDescFase() {
		return descFase;
	}

	public void setDescFase(String descFase) {
		this.descFase = descFase;
	}

	public String getDeseFase() {
		return deseFase;
	}

	public void setDeseFase(String deseFase) {
		this.deseFase = deseFase;
	}

	public String getDescTramite() {
		return descTramite;
	}

	public void setDescTramite(String descTramite) {
		this.descTramite = descTramite;
	}

	public String getDeseTramite() {
		return deseTramite;
	}

	public void setDeseTramite(String deseTramite) {
		this.deseTramite = deseTramite;
	}
	/**
	 * Gets the num acta.
	 * 
	 * @return the num acta
	 */
	public String getNumActa() {
		return this.numActa;
	}

	/**
	 * Sets the num acta.
	 * 
	 * @param numActa the new num acta
	 */
	public void setNumActa(String numActa) {
		this.numActa = numActa;
	}

	/**
	 * Gets the num acta territorio.
	 * 
	 * @return the num acta territorio
	 */
	public String getNumActaTerritorio() {
		return this.numActaTerritorio;
	}

	/**
	 * Sets the num acta territorio.
	 * 
	 * @param numActaTerritorio the new num acta territorio
	 */
	public void setNumActaTerritorio(String numActaTerritorio) {
		this.numActaTerritorio = numActaTerritorio;
	}

	/**
	 * Gets the num acta ano.
	 * 
	 * @return the num acta ano
	 */
	public String getNumActaAno() {
		return this.numActaAno;
	}

	/**
	 * Sets the num acta ano.
	 * 
	 * @param numActaAno the new num acta ano
	 */
	public void setNumActaAno(String numActaAno) {
		this.numActaAno = numActaAno;
	}

	/**
	 * Gets the version acta.
	 * 
	 * @return the version acta
	 */
	public String getVersionActa() {
		return this.versionActa;
	}

	/**
	 * Sets the version acta.
	 * 
	 * @param versionActa the new version acta
	 */
	public void setVersionActa(String versionActa) {
		this.versionActa = versionActa;
	}

	/**
	 * Sets the tamanyo.
	 * 
	 * @param tamanyo the new tamanyo
	 */
	public void setTamanyo (int tamanyo)
	{
		this.tamanyo=tamanyo;
	}
	
	/**
	 * Gets the tamanyo.
	 * 
	 * @return the tamanyo
	 */
	public int getTamanyo ()
	{
		return this.tamanyo;
	}
	
	/**
	 * Gets the file data.
	 * 
	 * @return the file data
	 */
	public InputStream getFileData()
	{
		return this.fileData;
	}
	
	/**
	 * Sets the file data.
	 * 
	 * @param fileData the new file data
	 */
	public void setFileData (InputStream fileData)
	{
		this.fileData=fileData;
	}
	
	/**
	 * Gets the usuario.
	 * 
	 * @return the usuario
	 */
	public String getUsuario() {
		return this.usuario;
	}
	
	/**
	 * Sets the usuario.
	 * 
	 * @param usuario the new usuario
	 */
	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}
	
	
	
	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombrePartido() {
		StringBuffer nombrePartido = new StringBuffer();
		
		if(null!=this.nombre && this.nombre.length()>20){
			nombrePartido = new StringBuffer();
			String nombreTemp = this.nombre;
			while(nombreTemp.length()>0){
				int tamanyo = nombreTemp.length();
				if(tamanyo>20){
					tamanyo=20;
				}
				nombrePartido.append(nombreTemp.substring(0, tamanyo)).append(" ");
				nombreTemp = nombreTemp.substring(tamanyo);
			}
		}else{
			nombrePartido = new StringBuffer(this.nombre);
		}
		
		return nombrePartido.toString();
	}
	
	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombre() {
		return this.nombre;
	}
	
	/**
	 * Sets the nombre.
	 * 
	 * @param nombre the new nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}
	
	/**
	 * Sets the tipo documento.
	 * 
	 * @param tipoDocumento the new tipo documento
	 */
	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}
	
	/**
	 * Gets the tipo documento.
	 * 
	 * @return the tipo documento
	 */
	public String getTipoDocumento() {
		return this.tipoDocumento;
	}
	
	
	
	/**
	 * Gets the fecha registro.
	 * 
	 * @return the fecha registro
	 */
	public String getFechaRegistro() {
		return this.fechaRegistro;
	}
	
	/**
	 * Sets the fecha registro.
	 * 
	 * @param fechaRegistro the new fecha registro
	 */
	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
	
	/**
	 * Sets the numero registro.
	 * 
	 * @param numeroRegistro the new numero registro
	 */
	public void setNumeroRegistro(String numeroRegistro) {
		this.numeroRegistro = numeroRegistro;
	}
	
	/**
	 * Gets the numero registro.
	 * 
	 * @return the numero registro
	 */
	public String getNumeroRegistro() {
		return this.numeroRegistro;
	}
	
	
	public String getEscomunicacion() {
		return escomunicacion;
	}

	public void setEscomunicacion(String escomunicacion) {
		this.escomunicacion = escomunicacion;
	}

	public String getNumInc() {
		return numInc;
	}

	public void setNumInc(String numInc) {
		this.numInc = numInc;
	}

	public String getNumIncAno() {
		return numIncAno;
	}

	public void setNumIncAno(String numIncAno) {
		this.numIncAno = numIncAno;
	}

	public String getNumIncTerritorio() {
		return numIncTerritorio;
	}

	public void setNumIncTerritorio(String numIncTerritorio) {
		this.numIncTerritorio = numIncTerritorio;
	}


	/**
	 * Row to bean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		if("actas".equals(otrosValores)){
			this.id=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_id);
			this.fileDataBlob=W83bDataBase.getBlobFromRS(rs, W83bActasBD.doc_documento);
			this.nombre=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_nombre);
			this.tipoDocumento=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_tipo);
			this.fechaRegistro=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_fechaReg);
			this.descTipo=W83bDataBase.getStringFromRS(rs, "DESCRIPCION");
			this.descFase=W83bDataBase.getStringFromRS(rs, "FASE");
			this.descTramite=W83bDataBase.getStringFromRS(rs, "TRAMITE");
			this.numeroRegistro=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_numReg);
			this.usuario=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_usuario);
			this.idRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.id_remesa_acuse_020);
			this.codRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.cod_remesa_acuse_020);
			this.idColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.id_coleccion_acuse_020);
			this.codColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.cod_coleccion_acuse_020);
			this.idEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.id_envio_acuse_020);
			this.codEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bActasBD.cod_envio_acuse_020);
		}else if("incidencias".equals(otrosValores)){
			this.id=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.id_doc_064_vista);
			this.fileDataBlob=W83bDataBase.getBlobFromRS(rs, W83bIncidenciasDocsBD.FICHERO_064);
			this.nombre=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.nomb_docu_064_vista);
			this.tipoDocumento=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.tp_doc_064_vista);

			this.fechaRegistro=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.f_reg_064_vista);
			this.descTipo=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_cas_069_vista);
			this.deseTipo=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_eus_069_vista);
			this.descFase=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_cas_052_vista);
			this.deseFase=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_eus_052_vista);
			this.descTramite=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_cas_012_vista);
			this.deseTramite=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.desc_eus_012_vista);
			this.numeroRegistro=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.num_reg_064_vista);
			this.idRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.ID_REMESA_ACUSE_064);
			this.codRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.COD_REMESA_ACUSE_064);
			this.idColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.ID_COLECCION_ACUSE_064);
			this.codColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.COD_COLECCION_ACUSE_064);
			this.idEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.ID_ENVIO_ACUSE_064);
			this.codEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.COD_ENVIO_ACUSE_064);
			if(null==this.numeroRegistro){
				this.numeroRegistro = "";
			}
			this.usuario=W83bDataBase.getStringFromRS(rs, W83bIncidenciasDocsBD.usuario_064_vista);
		}else{
			this.id=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.id_docu_038);
			this.fileDataBlob=W83bDataBase.getBlobFromRS(rs, W83bPreavisosBD.docu_038);
			this.nombre=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.nomb_docu_038);
			this.tipoDocumento=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.tp_doc_038);

			this.fechaRegistro=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.f_reg_038);
			this.descTipo=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_cas_069);
			this.deseTipo=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_eus_069);
			this.descFase=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_cas_052);
			this.deseFase=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_eus_052);
			this.descTramite=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_cas_012);
			this.deseTramite=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_eus_012);
			this.numeroRegistro=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.num_reg_038);
			if(null==this.numeroRegistro){
				this.numeroRegistro = "";
			}
			this.usuario=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.usuario_038);
			
			this.idRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.id_remesa_acuse_038);
			this.codRemesaAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.cod_remesa_acuse_038);
			this.idColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.id_coleccion_acuse_038);
			this.codColeccionAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.cod_coleccion_acuse_038);
			this.idEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.id_envio_acuse_038);
			this.codEnvioAcuse = W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.cod_envio_acuse_038);
		}
		return this;
	}

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 * 
	 * @param id the new id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the file data blob.
	 * 
	 * @return the file data blob
	 */
	public Blob getFileDataBlob() {
		return this.fileDataBlob;
	}

	/**
	 * Sets the file data blob.
	 * 
	 * @param fileDataBlob the new file data blob
	 */
	public void setFileDataBlob(Blob fileDataBlob) {
		this.fileDataBlob = fileDataBlob;
	}

	/**
	 * Gets the cod fase.
	 * 
	 * @return the cod fase
	 */
	public String getCodFase() {
		return this.codFase;
	}

	/**
	 * Sets the cod fase.
	 * 
	 * @param codFase the new cod fase
	 */
	public void setCodFase(String codFase) {
		this.codFase = codFase;
	}

	/**
	 * Gets the cod tramite.
	 * 
	 * @return the cod tramite
	 */
	public String getCodTramite() {
		return this.codTramite;
	}

	/**
	 * Sets the cod tramite.
	 * 
	 * @param codTramite the new cod tramite
	 */
	public void setCodTramite(String codTramite) {
		this.codTramite = codTramite;
	}

	/**
	 * Gets the desc tipo.
	 * 
	 * @return the desc tipo
	 */
	public String getDescTipo() {
		return this.descTipo;
	}

	/**
	 * Sets the desc tipo.
	 * 
	 * @param descTipo the new desc tipo
	 */
	public void setDescTipo(String descTipo) {
		this.descTipo = descTipo;
	}

	/**
	 * Gets the dese tipo.
	 * 
	 * @return the dese tipo
	 */
	public String getDeseTipo() {
		return this.deseTipo;
	}

	/**
	 * Sets the dese tipo.
	 * 
	 * @param deseTipo the new dese tipo
	 */
	public void setDeseTipo(String deseTipo) {
		this.deseTipo = deseTipo;
	}

	public String getNumPreaviso() {
		return numPreaviso;
	}

	public void setNumPreaviso(String numPreaviso) {
		this.numPreaviso = numPreaviso;
	}

	public String getNumPreavisoAno() {
		return numPreavisoAno;
	}

	public void setNumPreavisoAno(String numPreavisoAno) {
		this.numPreavisoAno = numPreavisoAno;
	}

	public String getNumPreavisoTerritorio() {
		return numPreavisoTerritorio;
	}

	public void setNumPreavisoTerritorio(String numPreavisoTerritorio) {
		this.numPreavisoTerritorio = numPreavisoTerritorio;
	}

	public String getNumImpugnacion() {
		return numImpugnacion;
	}

	public void setNumImpugnacion(String numImpugnacion) {
		this.numImpugnacion = numImpugnacion;
	}

	public String getNumImpugnacionAno() {
		return numImpugnacionAno;
	}

	public void setNumImpugnacionAno(String numImpugnacionAno) {
		this.numImpugnacionAno = numImpugnacionAno;
	}

	public String getNumImpugnacionTerritorio() {
		return numImpugnacionTerritorio;
	}

	public void setNumImpugnacionTerritorio(String numImpugnacionTerritorio) {
		this.numImpugnacionTerritorio = numImpugnacionTerritorio;
	}

	public String getDestinatarioComunicLaudo() {
		return destinatarioComunicLaudo;
	}

	public void setDestinatarioComunicLaudo(String destinatarioComunicLaudo) {
		this.destinatarioComunicLaudo = destinatarioComunicLaudo;
	}

	
	
}
